/* JAGUAR.C -- HP95LX (Jaguar) Commands and Support

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth

NOTE: This entire file is only compiled and linked on IBM PC (MSDOS)
systems.  Therefore, no #ifdef's are required.
*/

#include "freyja.h"

/* The following are excerpts from files Copyright 1990 by
Hewlett-Packard and Copyright 1990 by Lotus Development Corporation. */

/* ============================================================ */
/*#include "headers/settings.h"*/
#define MAX_MACRO_LEN	256

#define NAMEBUFLEN	30
#define TITLEBUFLEN	30
#define COMPANYBUFLEN	28

/*  settings */
typedef struct {
	int	Country;	/* */
	int	Volume; 	/* 1 speaker volume level 0ffh for off and 0-3 */
	int	Contrast;	/* 2 contrast level 1-5 */
	int	WeekStart;	/* 3 week starts SUNDAY or Monday */
	int	Punctuation;	/* 4 Punctuation format */
	int 	Language;	/* two character code for current language */
	int	DateFormat;	/* 6 current date format */
	int	TimeFormat;	/* 7 current time format */
	int	Sort;		/* 8 collating sequence */
	char	PicFile[80];	/* picture file name */
	char	Name_Buff[NAMEBUFLEN];	
	char	Title_Buff[TITLEBUFLEN]; 
	char	Company_Buff[COMPANYBUFLEN]; 
	int 	LanguageCount;
	int	LanguagesAvail[6];	/* MAX_LANG */
	char	LanguageMenu[66];	

	char	DateSeparator[2]; /* date separator  can be /-. */
	char	TimeSeparator[2]; /* time separator can be :., or h (for hms) */
	char	DateOrder;	/* */
	char	Time24;		/* use 24 hour time? */

	char	Currency[16];   /* currency string */
	int	CurrencyFix;   /* prefix or sufix */

	int	Keyboard;
	int	PrBaud; 	/* printer baud rate */
	int	PrDriver;	/* epson, hp, etc, by code */
	int 	PrInterface;	/* com 1, etc  */
	int	SystemRupt;		/* sysmgr interupt number - 60 default */
	int	CodePage;		/* for PC based - 437 or 850 based */
	int	ExitKeyCode;	/* for PC based - active exit key */
	int	MenuKeyCode;	/* for PC based - active menu key */
	int	CharKeyCode;	/* for PC based - active CHAR key toggle */
	int	Alarm[6];
} SETTINGS;


typedef struct {
	char	MacroFK;	   /* MacroFunctionKey Number 1-10 0 for not used */
        unsigned char MacroSize;   /* elements in the macro */
        char    CommentString[38]; /* MacroFunctionKey's Comment line */
	unsigned int MacroBody[MAX_MACRO_LEN];
} MACROHD;

/* ============================================================ */
/* #include "headers/interfac.h" */
#define SC_FILE 	5
#define SC_DTIME	11

#define F_M_GET_SYSDIR	(SC_FILE * 256) + 22
#define m_get_sysdir(a) 	      \
	c_service(F_M_GET_SYSDIR,(void far *)(a))

#define F_M_GET_SETTINGS (SC_DTIME *256) +9
#define m_get_settings(a,b)      \
	c_service(F_M_GET_SETTINGS, (void far *)(a),(void far *)(b))

/* ============================================================ */

	/* external key definitions */
#define APPT_KEY	0xB000
#define COMM_KEY	0xAC00
#define FILER_KEY	0xA800
#define HPCALC_KEY	0xC000
#define LOTUS_KEY	0xBC00
#define MEMO_KEY	0xB800
#define PHONE_KEY	0xB400
#define SETUP_KEY	0xA400
#define SPACE_KEY	0x3920

static MACROHD m;
static int *mac_ptr;
static int mac_len;

void J_Char();		/* int which */
void J_DoKey();		/* int key */

/* ------------------------------------------------------------ */

void
JInit()
	{
	SETTINGS s;

	if (c.g.parameter_1 == 'P' && c.g.key_type != 'C' &&
		c.g.key_type != 'S') JInitA();

	mac_len = 0;

	m_get_settings(&s, &m);
	DSetup(s.WeekStart);
#if !defined(NOCALC)
	USetup(s.Punctuation & 1 ? 0 : 1, s.Punctuation & 2 ? 0 : 1);
#endif
	}


/* ------------------------------------------------------------ */

void
JFini()
	{
	if (c.g.parameter_1 == 'P' && c.g.key_type != 'C' &&
		c.g.key_type != 'S') JFiniA();
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's appt key. */

void
JAppt()
	{
	J_DoKey(APPT_KEY);
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's comm key. */

void
JComm()
	{
	J_DoKey(COMM_KEY);
	}


/* ------------------------------------------------------------ */

/* End a redisplay. */

void
JDisEnd()
	{
	JLightOn();
	}


/* ------------------------------------------------------------ */

/* Start a redisplay. */

void
JDisStart()
	{
	JLightOff();
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's filer key. */

void
JFiler()
	{
	J_DoKey(FILER_KEY);
	}


/* ------------------------------------------------------------ */

/* Returns the default configuration file directory. DNAME must point
to an FNAMEMAX-sized buffer. */

void
JGetDir(dname)
	char *dname;
	{
	m_get_sysdir(dname);
	}


/* ------------------------------------------------------------ */

/* Get a key and handle Jaguar-specific translation. */

int
JGetKey()
	{
	int chr;

again:
	if (mac_len > 0) {
		mac_len--;
		chr = *mac_ptr++;
		}
	else	chr = JGetKeyA();

	if (chr & 0xFF) {	/* regular key */
		chr &= 0xFF;
		return(chr);
		}
	else	{
		chr >>= 8;
		chr &= 0xFF;
		if (chr == 0xC8) chr = 133;
		else if (chr == 0xA4) chr = 134;
		else if (chr == 0xA8) chr = 135;
		else if (chr == 0xAC) chr = 136;
		else if (chr == 0xB0) chr = 137;
		else if (chr == 0xB4) chr = 138;
		else if (chr == 0xB8) chr = 139;
		else if (chr == 0xBC) chr = 140;
		else if (chr == 0xC0) chr = 141;
		else if (chr >= 0xDB && chr <= 0xE4) {
			J_Char(chr - 0xDB + 1);
			goto again;
			}
		return(chr + 0x100);
		}
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's HP Calc key. */

void
JHPCalc()
	{
	J_DoKey(HPCALC_KEY);
	}


/* ------------------------------------------------------------ */

/* Check for a key press.  Return as KIsKey */

char
JIsKey()
	{
	return(mac_len > 0 || JIsKeyA() ? 'Y' : 'N');
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's Lotus key. */

void
JLotus()
	{
	J_DoKey(LOTUS_KEY);
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's memo key. */

void
JMemo()
	{
	J_DoKey(MEMO_KEY);
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's menu key. */

void
JMenu()
	{
	int chr;
	int which = 0;

	uarg = 0;

	chr = NUL;
	for (;;) {
		DJMenus(which);
		if (chr == CR)
			chr = "HOSQ"[which];
		else	chr = xtoupper(KGetChar());
		switch (chr) {

		case 'H':
			HHelp();
			return;
			/*break;*/

		case 'O':
			FFileFind();
			return;
			/*break;*/

		case 'S':
			FFileSave();
			return;
			/*break;*/

		case KEYQUIT:
		case 'Q':
			DJMenus(-1);
			MExit();
			if (doabort) JPushKeyA(0x3920);
			return;
			/*break;*/

		case KEYABORT:
		case BEL:
		case ESC:
			DJMenus(-1);
			return;
			/*break;*/

		case 0x100 + 75:	/* left arrow */
			--which;
			if (which < 0) which = 3;
			break;

		case SP:
		case 0x100 + 77:	/* right arrow */
			++which;
			if (which > 3) which = 0;
			break;

		case CR:
			break;

		default:
			TBell();
			break;
			}
		}
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's phone key. */

void
JPhone()
	{
	J_DoKey(PHONE_KEY);
	}


/* ------------------------------------------------------------ */

/* Handle the HP95LX's setup key. */

void
JSetup()
	{
	J_DoKey(SETUP_KEY);
	}


/* ------------------------------------------------------------ */

/* Switch input to the specified function key. */

void
J_Char(which)
	int which;
	{
	SETTINGS s;

	m.MacroFK = which;
	m_get_settings(&s, &m);

	if (which == m.MacroFK) {
		mac_ptr = (int *)(m.MacroBody);
		mac_len = m.MacroSize;
		}
	}


/* ------------------------------------------------------------ */

/* Handle each blue key. */

void
J_DoKey(key)
	int key;
	{
	uarg = 0;
	MExit();
	if (doabort) {
		JPushKeyA(SPACE_KEY);
		JPushKeyA(key);
		}
	}


/* end of JAGUAR.C -- HP95LX (Jaguar) Commands */
